#include "ShaderConstants.fxh"
#include "util.fxh"

struct PS_Input
{
    float4 position : SV_Position;
    float2 uv : TEXCOORD_0_FB_MSAA;
    float3 pos : POS;
};

struct PS_Output
{
    float4 color : SV_Target;
};


float2 rotate(in float2 p, in float t)
{
	return p * cos(-t) + float2(p.y, -p.x) * sin(-t);
}

float sun(float2 po)
{
	float c = 0.0;
	float l = TIME*0.832;
    float z = TIME*0.832;
    float2 uv = po;
    float2 p = po;
    //po -= 0.5;
    p = lerp(rotate(po, TIME*0.260),rotate(po, TIME*.05),smoothstep( 0.0, 1.0,length(po*1.272)));
    float r = 0.390;
    l = length(p);
    uv -= smoothstep(0.376, -0.152, p / l * - r) * abs(sin(l * 9.0 - z * 2.0));
    uv += smoothstep(-0.256, 0.064, p / l * r) * abs(sin( l * 9.0 - z * 2.0));
    c += 0.018 / length(abs(frac(uv * - 0.864) - 0.5));

    return c/l;
}



ROOT_SIGNATURE
void main(in PS_Input PSInput, out PS_Output PSOutput)
{
#if !defined(TEXEL_AA) || !defined(TEXEL_AA_FEATURE) || (VERSION < 0xa000 /*D3D_FEATURE_LEVEL_10_0*/) 
	float4 diffuse = TEXTURE_0.Sample(TextureSampler0, PSInput.uv);
#else
	float4 diffuse = texture2D_AA(TEXTURE_0, TextureSampler0, PSInput.uv);
#endif

#ifdef ALPHA_TEST
    if( diffuse.a < 0.5 )
    {
        discard;
    }
#endif

//diffuse.rgb = lerp(float3(5.0,5.0,5.0),float3(5.0,0.0,.0),smoothstep(0.0, 1.0, PSInput.pos.y*0.3));

    float v = 2.;
    float3 N = float3(0.0,0.0,0.0);
    float3 posi = PSInput.pos;
    //normalize
    float3 Np = normalize(cross(ddx(posi), ddy(posi)));
    N = normalize(float3(posi.x,posi.y*v,posi.z)) * v;

    diffuse.rgb = lerp(lerp(float3(0.0,0.0,0.0),float3(0.519,0.367,1.000),sun(N.xz)),FOG_COLOR.rgb,lerp(smoothstep(0.0, 0.1, length(N.xz*0.05)),1.0,N.y*0.5));

#ifdef IGNORE_CURRENTCOLOR
    PSOutput.color = diffuse;
#else
    PSOutput.color =  diffuse;
#endif

#ifdef WINDOWSMR_MAGICALPHA
    // Set the magic MR value alpha value so that this content pops over layers
    PSOutput.color.a = 133.0f / 255.0f;
#endif
}
